/*
 * Decompiled with CFR 0.152.
 */
package gg.essential.elementa.markdown.drawables;

import gg.essential.elementa.markdown.DrawState;
import gg.essential.elementa.markdown.MarkdownComponent;
import gg.essential.elementa.markdown.drawables.Drawable;
import gg.essential.elementa.markdown.selection.Cursor;
import gg.essential.universal.UMatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00010\u0002:\u00019B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0002\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0096\u0002J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013H\u0016J,\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\f\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\f\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0011\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u000bH\u0096\u0002J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0001H\u0016J\b\u0010&\u001a\u00020\u000fH\u0016J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00010(H\u0096\u0002J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0001H\u0016J \u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017H\u0014J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000100H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0001002\u0006\u0010$\u001a\u00020\u000bH\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000fH\u0016J\u0014\u00104\u001a\u00020\u001e2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00010\u0002J\u001e\u00106\u001a\b\u0012\u0004\u0012\u00020\u00010\u00022\u0006\u00107\u001a\u00020\u000b2\u0006\u00108\u001a\u00020\u000bH\u0016R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0002X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006:"}, d2={"Lgg/essential/elementa/markdown/drawables/DrawableList;", "Lgg/essential/elementa/markdown/drawables/Drawable;", "", "md", "Lgg/essential/elementa/markdown/MarkdownComponent;", "drawables", "(Lgg/essential/elementa/markdown/MarkdownComponent;Ljava/util/List;)V", "children", "getChildren", "()Ljava/util/List;", "size", "", "getSize", "()I", "contains", "", "element", "containsAll", "elements", "", "cursorAt", "Lgg/essential/elementa/markdown/selection/Cursor;", "mouseX", "", "mouseY", "dragged", "mouseButton", "cursorAtEnd", "cursorAtStart", "draw", "", "matrixStack", "Lgg/essential/universal/UMatrixStack;", "state", "Lgg/essential/elementa/markdown/DrawState;", "get", "index", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "layoutImpl", "Lgg/essential/elementa/markdown/drawables/Drawable$Layout;", "x", "y", "width", "listIterator", "", "selectedText", "", "asMarkdown", "setDrawables", "newDrawables", "subList", "fromIndex", "toIndex", "Direction", "Elementa"})
@SourceDebugExtension(value={"SMAP\nDrawableList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawableList.kt\ngg/essential/elementa/markdown/drawables/DrawableList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1849#2,2:134\n1858#2,3:136\n1849#2,2:139\n1849#2,2:141\n764#2:143\n855#2,2:144\n*S KotlinDebug\n*F\n+ 1 DrawableList.kt\ngg/essential/elementa/markdown/drawables/DrawableList\n*L\n32#1:134,2\n35#1:136,3\n45#1:139,2\n103#1:141,2\n107#1:143\n107#1:144,2\n*E\n"})
public final class DrawableList
extends Drawable
implements List<Drawable>,
KMappedMarker {
    private List<? extends Drawable> drawables;

    public DrawableList(@NotNull MarkdownComponent md, @NotNull List<? extends Drawable> drawables) {
        Intrinsics.checkNotNullParameter(md, "md");
        Intrinsics.checkNotNullParameter(drawables, "drawables");
        super(md);
        this.setDrawables(drawables);
    }

    @Override
    @NotNull
    public List<Drawable> getChildren() {
        List<Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDrawables(@NotNull List<? extends Drawable> newDrawables) {
        Intrinsics.checkNotNullParameter(newDrawables, "newDrawables");
        this.drawables = newDrawables;
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            it.setParent(this);
        }
        Drawable.Companion.trim(this);
        Iterable $this$forEachIndexed$iv = this;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void drawable;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Drawable drawable2 = (Drawable)item$iv;
            int index = n;
            boolean bl = false;
            if (index > 0) {
                drawable.setPrevious(this.get(index - 1));
            }
            if (index == CollectionsKt.getLastIndex(this)) continue;
            drawable.setNext(this.get(index + 1));
        }
    }

    @Override
    @NotNull
    protected Drawable.Layout layoutImpl(float x, float y, float width) {
        float currY = 0.0f;
        currY = y;
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            currY += it.layout(x, currY, width).getHeight();
        }
        float height = currY - y;
        return new Drawable.Layout(x, y, width, height, null, 16, null);
    }

    @Override
    @NotNull
    public Cursor<?> cursorAt(float mouseX, float mouseY, boolean dragged, int mouseButton) {
        Cursor<?> cursor;
        Drawable closestDrawable = null;
        float closestDistance = Float.MAX_VALUE;
        Enum direction = null;
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        for (Drawable drawable : list) {
            if (drawable.isHovered(mouseX, mouseY)) {
                return drawable.cursorAt(mouseX, mouseY, dragged, mouseButton);
            }
            if (mouseY < drawable.getY()) {
                if (!(drawable.getY() - mouseY < closestDistance)) continue;
                direction = Direction.Up;
                closestDistance = drawable.getY() - mouseY;
                closestDrawable = drawable;
                continue;
            }
            if (mouseY > drawable.getY() + drawable.getHeight()) {
                if (!(drawable.getY() + drawable.getHeight() - mouseY < closestDistance)) continue;
                direction = Direction.Down;
                closestDistance = mouseY - (drawable.getY() + drawable.getHeight());
                closestDrawable = drawable;
                continue;
            }
            closestDistance = 0.0f;
            closestDrawable = drawable;
            Enum enum_ = direction = mouseX < drawable.getX() ? Direction.Left : Direction.Right;
            break;
        }
        if (closestDrawable == null || closestDistance == Float.MAX_VALUE || direction == null) {
            throw (Throwable)new NotImplementedError(null, 1, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1: {
                cursor = closestDrawable.cursorAtStart();
                break;
            }
            case 2: {
                cursor = closestDrawable.cursorAtEnd();
                break;
            }
            case 3: 
            case 4: {
                cursor = closestDrawable.cursorAt(mouseX, mouseY, dragged, mouseButton);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return cursor;
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtStart() {
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return CollectionsKt.first(list).cursorAtStart();
    }

    @Override
    @NotNull
    public Cursor<?> cursorAtEnd() {
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return CollectionsKt.last(list).cursorAtEnd();
    }

    @Override
    public void draw(@NotNull UMatrixStack matrixStack, @NotNull DrawState state) {
        Intrinsics.checkNotNullParameter(matrixStack, "matrixStack");
        Intrinsics.checkNotNullParameter(state, "state");
        Iterable $this$forEach$iv = this;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Drawable it = (Drawable)element$iv;
            boolean bl = false;
            it.drawCompat(matrixStack, state);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String selectedText(boolean asMarkdown) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Drawable it = (Drawable)element$iv$iv;
            boolean bl = false;
            if (!it.hasSelectedText()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, "\n\n", null, null, 0, null, new Function1<Drawable, CharSequence>(asMarkdown){
            final /* synthetic */ boolean $asMarkdown;
            {
                this.$asMarkdown = $asMarkdown;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull Drawable it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.selectedText(this.$asMarkdown);
            }
        }, 30, null);
    }

    public int getSize() {
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.size();
    }

    public boolean contains(@NotNull Drawable element) {
        Intrinsics.checkNotNullParameter(element, "element");
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.containsAll(elements);
    }

    @Override
    @NotNull
    public Drawable get(int index) {
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.get(index);
    }

    public int indexOf(@NotNull Drawable element) {
        Intrinsics.checkNotNullParameter(element, "element");
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Drawable> iterator() {
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.iterator();
    }

    public int lastIndexOf(@NotNull Drawable element) {
        Intrinsics.checkNotNullParameter(element, "element");
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<Drawable> listIterator() {
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<Drawable> listIterator(int index) {
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.listIterator(index);
    }

    @Override
    @NotNull
    public List<Drawable> subList(int fromIndex, int toIndex) {
        List<? extends Drawable> list = this.drawables;
        if (list == null) {
            Intrinsics.throwUninitializedPropertyAccessException("drawables");
            list = null;
        }
        return list.subList(fromIndex, toIndex);
    }

    @Override
    public boolean add(Drawable element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, Drawable element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends Drawable> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Drawable> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Drawable remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<Drawable> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Drawable set(int index, Drawable element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super Drawable> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgg/essential/elementa/markdown/drawables/DrawableList$Direction;", "", "(Ljava/lang/String;I)V", "Up", "Down", "Left", "Right", "Elementa"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction Up = new Direction();
        public static final /* enum */ Direction Down = new Direction();
        public static final /* enum */ Direction Left = new Direction();
        public static final /* enum */ Direction Right = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.Up, Direction.Down, Direction.Left, Direction.Right};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.Up.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Down.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Left.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.Right.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

